;; TODO
;; 3. add birth/death
;; 4. add immigration

turtles-own
[
  unaffiliated-utility                                                  ;; utility of unaffiliation for individual
  affiliation                                                           ;; 1 is unaffiliated, 0 is affiliated
]

to setup
  clear-all
  setup-nodes
  if network? [ setup-spatially-clustered-network ]
  reset-ticks
end

to setup-nodes
  set-default-shape turtles "person"
  create-turtles community-size
  [
    set size 2
    setxy (random-xcor * 0.95) (random-ycor * 0.95)
    set unaffiliated-utility random-normal u-x u-x-var                    ;; set individual utility for being unaffiliated
    if unaffiliated-utility > 1 [set unaffiliated-utility 1]              ;; make sure utility falls in [0,1]
    if unaffiliated-utility < 0 [set unaffiliated-utility 0]
    set affiliation 0                                                     ;; set all to affiliated first
    set color blue                                                        ;; affiliated will be blue
    if random-float 1 < initial-x [ set affiliation 1 set color red ]     ;; set initial proportion to unaffiliated, will be red
  ]
end

;; Taken from Uri Wilensky's 'Virus on a Network'
to setup-spatially-clustered-network
  let num-links (average-node-degree * community-size) / 2
  while [count links < num-links ]
  [
    ask one-of turtles
    [
      let choice (min-one-of (other turtles with [not link-neighbor? myself])
                   [distance myself])
      if choice != nobody [ create-link-with choice ]
    ]
  ]
  ; make the network look a little prettier
  repeat 10 [ layout-spring turtles links 0.3 (world-width / (sqrt community-size)) 1 ]
end

to go
  let affiliated-turtles turtles with [affiliation < 0.5]
  let unaffiliated-turtles turtles with [affiliation > 0.5]

  ifelse network? [ switch-with-network affiliated-turtles unaffiliated-turtles ]
  [ switch-without-network affiliated-turtles unaffiliated-turtles ]

  tick
end

to switch-without-network [ affiliated-turtles unaffiliated-turtles ]
  ;; affiliated turtles switch with probability
  ask affiliated-turtles [
     if random-float 1 < time-scale * (unaffiliated-utility * proportion-unaffiliated ^ affiliation-power)
        [ set affiliation 1 set color red ]
  ]
  ;; unaffiliated turtles switch with probability
  ask unaffiliated-turtles [
     if random-float 1 < time-scale * ((1 - unaffiliated-utility ) * (1 - proportion-unaffiliated) ^ affiliation-power)
        [ set affiliation 0 set color blue ]
  ]
end

to switch-with-network [ affiliated-turtles unaffiliated-turtles ]
  ;; affiliated turtles switch with probability
  ask affiliated-turtles [
     if random-float 1 < time-scale * (unaffiliated-utility * proportion-neighbors-unaffiliated ^ affiliation-power) [
       change-affiliation unaffiliated-turtles affiliated-turtles ]
     if count unaffiliated-turtles > 0 [make-friends unaffiliated-turtles]
  ]
  ;; unaffiliated turtles switch with probability
  ask unaffiliated-turtles [
     if random-float 1 < time-scale * ((1 - unaffiliated-utility ) * (1 - proportion-neighbors-unaffiliated) ^ affiliation-power) [
       change-affiliation affiliated-turtles unaffiliated-turtles ]
     if count affiliated-turtles > 0 [make-friends affiliated-turtles]
  ]
  ;; make network more elastic
  pretty-network
end

;; turtle procedure
to change-affiliation [ in-group out-group ]
  ifelse color = blue [ set color red ] [ set color blue ]
  ifelse affiliation > 0.5 [ set affiliation 0 ] [ set affiliation 1 ]
  let diff-neighbors link-neighbors with [abs(affiliation - [affiliation] of myself) > 0.5]
  if count diff-neighbors > 0 [ break-friendships diff-neighbors ]
end

;; turtle procedure
to break-friendships [diff-neighbors]
  ;; if you have more differently affiliated friends than you want, kill friendships
  let num-unwanted-friends count diff-neighbors - round ( (1 - min-friend-similarity) * count link-neighbors)
  if num-unwanted-friends > 0 [
    let unwanted-friends n-of num-unwanted-friends diff-neighbors
    ask unwanted-friends [ ask link-with myself [ die ] ]
  ]
end

;; turtle procedure
to make-friends [in-group]
  ;; make a similarly affiliated nearby friend proportional to your loneliness (i.e. inversely proportional to number of friends)
  if random 100 < (new-friend-chance / ( count link-neighbors + 1 )) and count link-neighbors < max-friends [
  ask min-one-of in-group [distance myself] [create-link-with myself] ]
end

to pretty-network
  repeat 10 [ layout-spring turtles links 0.3 (world-width / (sqrt community-size)) 1]
end

to-report proportion-unaffiliated
  report ( count turtles with [affiliation > 0.5] ) / ( count turtles )
end

to-report proportion-neighbors-unaffiliated
  ifelse count link-neighbors > 1 [
  report ( count link-neighbors with [affiliation > 0.5] ) / ( count link-neighbors ) ]
  [ report 0 ]
end
@#$#@#$#@
GRAPHICS-WINDOW
480
11
941
493
20
20
11.0
1
10
1
1
1
0
0
0
1
-20
20
-20
20
1
1
1
ticks
30.0

SLIDER
24
50
229
83
initial-x
initial-x
0.0
1.0
0.05
0.01
1
NIL
HORIZONTAL

BUTTON
23
89
118
129
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
133
89
228
129
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

PLOT
221
328
476
492
Affiliation proportions
time
fraction people
0.0
52.0
0.0
1.0
true
true
"" ""
PENS
"affiliated" 1.0 0 -13345367 true "" "plot (count turtles with [affiliation < 0.5]) / (count turtles)"
"unaffiliated" 1.0 0 -2674135 true "" "plot (count turtles with [affiliation > 0.5]) / (count turtles)"

SLIDER
25
15
230
48
community-size
community-size
10
300
300
5
1
NIL
HORIZONTAL

SLIDER
22
135
229
168
u-x
u-x
0
1
0.62
0.01
1
NIL
HORIZONTAL

SLIDER
270
126
475
159
average-node-degree
average-node-degree
1
community-size - 1
6
1
1
NIL
HORIZONTAL

SLIDER
21
207
228
240
time-scale
time-scale
0.1
1.0
0.1
0.1
1
NIL
HORIZONTAL

SLIDER
22
170
228
203
u-x-var
u-x-var
0
0.35
0.3
0.01
1
NIL
HORIZONTAL

PLOT
255
162
475
325
Utility distribution
utility
distribution
0.0
1.0
0.0
10.0
true
false
"" ""
PENS
"default" 0.05 1 -16777216 true "" "histogram [unaffiliated-utility] of turtles"

SWITCH
269
15
474
48
network?
network?
0
1
-1000

SLIDER
21
243
227
276
affiliation-power
affiliation-power
0
1.5
1
0.01
1
NIL
HORIZONTAL

SLIDER
270
52
474
85
min-friend-similarity
min-friend-similarity
0
1
0.7
0.01
1
NIL
HORIZONTAL

SLIDER
270
89
474
122
new-friend-chance
new-friend-chance
0
100
0.5
0.5
1
%
HORIZONTAL

PLOT
22
328
214
492
links
time
links
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot count links"

SLIDER
21
282
228
315
max-friends
max-friends
0
community-size - 1
12
1
1
NIL
HORIZONTAL

@#$#@#$#@
## WHAT IS IT?

This model demonstrates the dynamics of religious affiliation switching. People claiming no religious affiliation constitute the fastest growing religious minority in many countries, including the United States (Martin 2006). In fact, the religious "nones" are the only group growing in all 50 US states (Kosmin 2009). Although many scholars attribute the decline of religious affiliation to generational changes, roughly half of the US population changes religious affiliation at some point in their life, often several times (Pew 2009). This suggests that religious affiliation shift can be modeled as social group competition, with different religious groups competing for members (Abrams 2011). Such models predict that religious coexistence is not a stable state; the unaffiliated group will grow until all organized religion has disappeared. Whether or not this comes to fruition, all people have a stake in the outcome.

## HOW IT WORKS

Initially, COMMUNITY-SIZE agents are given a random unaffiliated utility sampled from a normal distribution with mean U-X and standard deviation U-X-VAR (taken to be 0 for initial tests). A proportion INITIAL-X of the population is unaffiliated and the rest are affiliated.

At each tick, affiliated agents switch to unaffiliated with probability TIME-SCALE $*u_x*x^a$, where $a$ is initially set to 1 to test agreement with \eqref{abramsds}. Unaffiliated agents switch to affiliated with probability TIME-SCALE $* (1-u_x)*(1-x)^a$.

At each tick, people switch affiliations according the previous transition probabilities. However, if an agent switches from affiliated to unaffiliated (or vice versa) in that time step, it will lose some affiliated friends, but it may gain a new unaffiliated friend.

Each time an agent switches from affiliated to unaffiliated, it calculates what proportion of its friends are unaffiliated. If that proportion is less than the MIN-FRIEND-SIMILARITY desired by all agents, the agent break ties with random affiliated friends until the MIN-FRIEND-SIMILARITY proportion is reached.

In addition to losing friends after switching from affiliated to unaffiliated, each agent might gain a new similarly affiliated friend proportional to his loneliness; in other words, the agent will make friends with the nearest similarly affiliated agent with probability NEW-FRIEND-CHANCE / (number-friends + 1). If an agent already has MAX-FRIENDS, it won't attempt to make more friends.

## HOW TO USE IT

Using the sliders, choose the COMMUNITY-SIZE and the AVERAGE-NODE-DEGREE (average number of links coming out of each node).

If NETWORK? is on, a network is created based on proximity (Euclidean distance) between nodes.  A node is randomly chosen and connected to the nearest node that it is not already connected to.  This process is repeated until the network has the correct number of links to give the specified average node degree.

The INITIAL-X slider determines how many of the nodes will start the simulation unaffiliated.

The U-X and U-VAR-X sliders change the mean and standard deviation, respectively, of the distribution of initial unaffiliated utilities for agents.

Then press SETUP to create the network.  Press GO to run the model.

The TIME-SCALE slide determines how fast the reactions happen. The AFFILIATION-POWER slider determines the exponent of the power law transition rate.

The MIN-FRIEND-SIMILARITY slide determines the minimum proportion of similarly affiliated friends desired by all agents. The NEW-FRIEND-CHANCE slider is the chance of making a new friend each time step if you have no friends. The MAX-FRIENDS slider determines how many friends an agent must have before it stops looking for more friends.

## THINGS TO NOTICE

As the simulation runs, notice how the proportion of unaffiliated and affiliated members of the population changes. Do the group affiliation proportions settle into an equilibrium state?

Also notice how the number of links (friendships) changes over time. Are friendships mostly forming or breaking? How does that correlate with the population affiliation breakdown?

Finally notice how the visual representation of the network changes. The initial network is spacially clustered, but how does that change over time?

## THINGS TO TRY

Try changing the distribution of utilities using the U-X and U-X-VAR sliders. How does this affect the final state?

Try changing the initial proportion of unaffiliated members INITIAL-X. Does this have any effect on the final outcome?

Try changing the AFFILIATION-POWER? See what the difference is on the equilibrium state for values above and below 1. How does the value change the shape of the affiliation proportion curves?

Try changing MIN-FRIEND-SIMILARITY and NEW-FRIEND-CHANCE. How does this affect the number of links over time? Does it impact the final state or the visual representation of the network?

## EXTENDING THE MODEL

Try incorporating birth, death, and immigration into the model. Different affiliations may have different birth and death rates. Immigrants may have different religious affiliations from the current population.

## NETLOGO FEATURES

This model does not use the NW extention, so I use layout-spring to make the network more visually appealing.

## RELATED MODELS

The network setup is based on Uri Wilensky's Virus on a Network:
http://ccl.northwestern.edu/netlogo/models/VirusonaNetwork

## CREDITS AND REFERENCES
NetLogo Modeling Commons URL:
http://modelingcommons.org/browse/one_model/4620#model_tabs_browse_info

Abrams et al. paper:
http://dmabrams.esam.northwestern.edu/pubs/Abrams%20Yaple%20and%20Wiener%20-%20Dynamics%20of%20social%20group%20competition---modeling%20the%20decline%20of%20religious%20affiliation%20-%20PRL%20107,%20088701%20(2011).pdf
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 6.0-M5
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="experiment_uvar" repetitions="10" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1500"/>
    <metric>(count turtles with [affiliation &gt; 0.5]) / (count turtles)</metric>
    <enumeratedValueSet variable="average-node-degree">
      <value value="6"/>
    </enumeratedValueSet>
    <steppedValueSet variable="u-x-var" first="0" step="0.05" last="0.35"/>
    <enumeratedValueSet variable="affiliation-power">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-x">
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="u-x">
      <value value="0.65"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="community-size">
      <value value="300"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="network?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="time-scale">
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="min-friend-similarity">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="new-friend-chance">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-friends">
      <value value="12"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment_a" repetitions="10" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1500"/>
    <metric>(count turtles with [affiliation &gt; 0.5]) / (count turtles)</metric>
    <enumeratedValueSet variable="average-node-degree">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="u-x-var">
      <value value="0.2"/>
    </enumeratedValueSet>
    <steppedValueSet variable="affiliation-power" first="0.6" step="0.05" last="1"/>
    <enumeratedValueSet variable="initial-x">
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="u-x">
      <value value="0.65"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="community-size">
      <value value="300"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="network?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="time-scale">
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="min-friend-similarity">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="new-friend-chance">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-friends">
      <value value="12"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment_friendsim" repetitions="10" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1500"/>
    <metric>(count turtles with [affiliation &gt; 0.5]) / (count turtles)</metric>
    <enumeratedValueSet variable="average-node-degree">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="u-x-var">
      <value value="0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="affiliation-power">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-x">
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="u-x">
      <value value="0.65"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="community-size">
      <value value="300"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="network?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="time-scale">
      <value value="0.1"/>
    </enumeratedValueSet>
    <steppedValueSet variable="min-friend-similarity" first="0" step="0.1" last="1"/>
    <enumeratedValueSet variable="new-friend-chance">
      <value value="0.5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-friends">
      <value value="12"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experimentNE" repetitions="10" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>(count turtles with [affiliation &gt; 0.5]) / (count turtles)</metric>
    <enumeratedValueSet variable="affiliation-power">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-x">
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="time-scale">
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="new-friend-chance">
      <value value="0.5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-friends">
      <value value="12"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="community-size">
      <value value="300"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="u-x-var">
      <value value="0.3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="network?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="u-x">
      <value value="0.55"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="min-friend-similarity">
      <value value="0.7"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="average-node-degree">
      <value value="6"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experimentNZ" repetitions="10" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>(count turtles with [affiliation &gt; 0.5]) / (count turtles)</metric>
    <enumeratedValueSet variable="affiliation-power">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-x">
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="time-scale">
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="new-friend-chance">
      <value value="0.5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-friends">
      <value value="12"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="community-size">
      <value value="300"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="u-x-var">
      <value value="0.3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="network?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="u-x">
      <value value="0.67"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="min-friend-similarity">
      <value value="0.7"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="average-node-degree">
      <value value="6"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experimentCZ" repetitions="10" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>(count turtles with [affiliation &gt; 0.5]) / (count turtles)</metric>
    <enumeratedValueSet variable="affiliation-power">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-x">
      <value value="0.05"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="time-scale">
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="new-friend-chance">
      <value value="0.5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-friends">
      <value value="12"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="community-size">
      <value value="300"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="u-x-var">
      <value value="0.3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="network?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="u-x">
      <value value="0.62"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="min-friend-similarity">
      <value value="0.7"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="average-node-degree">
      <value value="6"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
