globals [
  s-pull-patches
  h-pull-patches
  l-pull-patches

  low-payoff
  high-payoff
  stable-payoff
  low-number
  high-number
  stable-number

  lpay
  hpay

  tau
  tau-list
  ; replication?

]

breed [masters master]
breed [i-s-agents i-s-agent]
breed [i-l-agents i-l-agent]
breed [i-h-agents i-h-agent]
breed [r1-agents r1-agent]
breed [r2-agents r2-agent]
breed [r3-agents r3-agent]
breed [random-agents random-agent]

turtles-own [
   my-choices
   my-payoff
   my-wealth
   current-choice
   current-payoff
   commission
   wealth
   ; my-data
]

to setup

  ca

  set s-pull-patches patches with [ pxcor <= 5 and pxcor >= -5]
  ask s-pull-patches
  [set pcolor 87]

  set h-pull-patches patches with [  pxcor > 5 ]
  ask h-pull-patches
  [set pcolor 47]

  set l-pull-patches patches with [pxcor < -5]
  ask l-pull-patches
  [ set pcolor 137]

  if scenario = "Random" [
   set replication? false
  create-random-agents num-random-agents[
   set shape "face happy"
   set color yellow
   set size 2
  ]

    create-masters num-masters
  [
  set size 5
  set color green]

    set num-i-s-agents 0
    set num-i-l-agents 0
    set num-i-h-agents 0

  ]

  if scenario = "Irrational-I" [
    set replication? false
  set num-random-agents 0

    create-masters num-masters
  [
  set size 5
  set color green]

    create-i-s-agents num-i-s-agents
    [
      set size 3
      set color sky]

     create-i-l-agents num-i-l-agents
     [
      set size 3
      set color brown]

     create-i-h-agents num-i-h-agents
     [
        set size 3
      set color red]

  ]

   if scenario = "Meta-2" [
     set replication? false

  set num-random-agents 0

    create-masters num-masters
  [
  set size 5
  set color green]

    create-i-s-agents 18
    [
      set size 3
      set color sky]

     create-i-l-agents 16
     [
      set size 3
      set color brown]

     create-i-h-agents 16
     [
        set size 3
      set color red]
  ]

   if scenario = "Meta-1" [

  set num-random-agents 0

    create-masters num-masters
  [
  set size 5
  set color green]

    create-i-s-agents 48
    [
      set size 3
      set color sky]

     create-i-l-agents 1
     [
      set size 3
      set color brown]

     create-i-h-agents 1
     [
        set size 3
      set color red]

    if replication? = true [

    create-r1-agents num-r1-agents
     [
        set size 3
      set color orange]

      create-r2-agents 1
     [
        set size 3
      set color black]

      create-r3-agents 1
     [
        set size 3
      set color 44]
    ]

  ]

  if scenario = "Meta-3" [
     set replication? false

  set num-random-agents 0

    create-masters num-masters
  [
  set size 5
  set color green]

    create-i-s-agents 4
    [
      set size 3
      set color sky]

     create-i-l-agents 23
     [
      set size 3
      set color brown]

     create-i-h-agents 23
     [
        set size 3
      set color red]
  ]


   ask turtles [
   set my-choices []
   ]

  set low-number []
  set high-number []
  set stable-number []
  set low-payoff []
  set high-payoff []
  set stable-payoff []

   ask turtles [
   set my-payoff []
  ]

  set tau-list []
  set tau 0

  ask turtles [
    set my-wealth []
  ]


  ask turtles [
    set wealth []
  ]

  reset-ticks
end

to go

   if ticks >= 100 [stop]

  ifelse ticks != 0
   [ask turtles [choose]];[
   [ask turtles [setxy random-xcor random-ycor]]

   ask turtles [update-choice]
   ask turtles [set my-choices fput current-choice my-choices]

   generate-low-number
   generate-high-number
   generate-stable-number

   generate-low-payoff
   generate-high-payoff
   generate-stable-payoff

   ask turtles [update-payoff]
   ask turtles [set my-payoff fput current-payoff my-payoff]

  ifelse ticks != 0
   [set tau random-float max-tau]
   [set tau 0]
   set tau-list fput tau tau-list

   ask turtles [pay-commission]

   ask turtles [update-wealth]

  ask turtles [set wealth fput (sum my-wealth) wealth]

  tick
end

to choose
  let choice strategy
  if choice = 0
  [ move-to one-of s-pull-patches ]

  if choice = 1
  [ move-to one-of l-pull-patches]

  if choice = 2
  [move-to one-of h-pull-patches]
end

to-report strategy

  if scenario = "Random" [

    if breed = random-agents
     [report random 3]

    if (breed = masters)
  [ifelse ticks > t-threshold
    [ifelse (2500 - (sum ( map * (low-payoff) (low-number)))) > (2500 - (sum ( map * (high-payoff) (high-number))))
     [report 1]
     [report 2]]
    [report random 3]

  ]
  ]
   if scenario = "Irrational-I" [

    if breed = random-agents
     [report random 3]

    if (breed = masters)
  [ifelse ticks > t-threshold
    [ifelse (2500 - (sum ( map * (low-payoff) (low-number)))) > (2500 - (sum ( map * (high-payoff) (high-number))))
     [report 1]
     [report 2]]
    [report random 3]

  ]

  if ( breed = i-s-agents )
      [report 0]

     ifelse (breed = i-l-agents and (first low-payoff > first high-payoff))
     [report 1]
     [report 2]

    ifelse (breed = i-h-agents and (first high-payoff > first low-payoff))
       [report 1]
       [report 2]
]
  if scenario = "Meta-1" [

  if (breed = masters)
  [ifelse ticks > t-threshold
    [ifelse (2500 - (sum ( map * (low-payoff) (low-number)))) > (2500 - (sum ( map * (high-payoff) (high-number))))
     [report 1]
     [report 2]]
    [report random 3]
    ]

     if ( breed = i-s-agents )
      [report 0]

     if (breed = i-l-agents)
     [report 1]


    if  (breed = i-h-agents)
       [report 2]

  ]
  if scenario = "Meta-1" and replication? = true
  [
  if ( breed = r1-agents)
    [report 0]
     if ( breed = r2-agents)
    [report 1]
     if ( breed = r3-agents)
    [report 2]
  ]

   if scenario = "Meta-2" [

  if (breed = masters)
  [ifelse ticks > t-threshold
    [ifelse (2500 - (sum ( map * (low-payoff) (low-number)))) > (2500 - (sum ( map * (high-payoff) (high-number))))
     [report 1]
     [report 2]]
    [report random 3]
    ]

     if ( breed = i-s-agents )
      [report 0]

     if (breed = i-l-agents)
     [report 1]


    if  (breed = i-h-agents)
       [report 2]

  ]

  if scenario = "Meta-3" [

  if (breed = masters)
  [ifelse ticks > t-threshold
    [ifelse (2500 - (sum ( map * (low-payoff) (low-number)))) > (2500 - (sum ( map * (high-payoff) (high-number))))
     [report 1]
     [report 2]]
    [report random 3]
    ]

     if ( breed = i-s-agents )
      [report 0]

     if (breed = i-l-agents)
     [report 1]


    if  (breed = i-h-agents)
       [report 2]

  ]

end

to generate-low-number
  if ticks >= 0
  [set low-number fput (count turtles-on l-pull-patches) low-number]
end

to generate-high-number
  if ticks >= 0
  [set high-number fput (count turtles-on h-pull-patches) high-number]
end

to generate-stable-number
  if ticks >= 0
  [set stable-number fput (count turtles-on s-pull-patches) stable-number]
end

to generate-low-payoff
  ifelse first low-number > 0
  [
  ifelse random-float 1 < 0.5
  [set lpay 40]
  [set lpay 0]

  set low-payoff fput (lpay / first low-number) low-payoff
  ]
  [
    ifelse random-float 1 < 0.5
  [set lpay 40]
  [set lpay 0]
    set low-payoff fput lpay low-payoff
  ]
end

to generate-high-payoff
  ifelse first high-number > 0
  [
   ifelse random-float 1 < 0.25
  [set hpay 80]
  [set hpay 0]

  set high-payoff fput (hpay / first high-number) high-payoff
  ]
  [
    ifelse random-float 1 < 0.25
  [set hpay 80]
  [set hpay 0]

  set high-payoff fput hpay high-payoff
  ]
end

to generate-stable-payoff
   set stable-payoff fput 1 stable-payoff
end

to update-choice

  ask turtles-on patches with [pcolor =  87]
  [set current-choice  0]

  ask turtles-on patches with [pcolor = 137]
  [set current-choice  1]

  ask turtles-on patches with [pcolor = 47]
  [set current-choice  2]
end

to update-payoff

  ask turtles-on patches with [pcolor =  87]
  [set current-payoff 1]

  ask turtles-on patches with [pcolor = 137]
  [set current-payoff first low-payoff]

  ask turtles-on patches with [pcolor = 47]
  [set current-payoff first high-payoff]

end

to pay-commission
  ifelse ticks > 0 [
    ifelse  item 0 my-choices = item 1 my-choices
    [set commission 0]
    [set commission tau]
  ]
  [ set commission 0]

end

to update-wealth
   let earning (current-payoff - commission)
   set my-wealth fput earning my-wealth
end

to-report f-wealth
 report sum my-wealth
end


@#$#@#$#@
GRAPHICS-WINDOW
437
28
742
334
-1
-1
9.0
1
10
1
1
1
0
0
0
1
-16
16
-16
16
1
1
1
ticks
30.0

BUTTON
27
10
90
43
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
108
10
171
43
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
232
47
404
80
num-random-agents
num-random-agents
0
100
0.0
1
1
NIL
HORIZONTAL

SLIDER
232
87
404
120
num-masters
num-masters
0
50
3.0
1
1
NIL
HORIZONTAL

SLIDER
235
128
407
161
max-tau
max-tau
0
5
5.0
0.1
1
NIL
HORIZONTAL

SLIDER
236
168
408
201
t-threshold
t-threshold
1
90
2.0
1
1
NIL
HORIZONTAL

TEXTBOX
471
10
509
28
LOW
11
0.0
1

TEXTBOX
573
10
614
28
STABLE
11
0.0
1

TEXTBOX
666
10
699
28
HIGH
11
0.0
1

CHOOSER
16
50
221
95
Scenario
Scenario
"Random" "Irrational-I" "Rational-R" "Meta-1" "Meta-2" "Meta-3"
1

PLOT
14
108
228
228
Low-payoff
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 1 -7858858 true "" "if ticks != 0 [plot first low-payoff]"

PLOT
12
232
230
352
High-payoff
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 1 -2674135 true "" "if ticks != 0 [ plot first high-payoff ]"

PLOT
755
59
1118
330
plot 1
NIL
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"mean-t" 1.0 0 -13840069 true "" "if ticks > 1 [Plot mean [f-wealth] of turtles]"
"mean-m" 1.0 0 -7500403 true "" "if ticks > 1 and num-masters > 0 [Plot mean [f-wealth] of masters]"
"mean-i-h" 1.0 0 -2674135 true "" "if scenario = \"Irrational-I\" and num-i-h-agents > 0 and ticks > 1 [Plot mean [f-wealth] of i-h-agents];Plot [aggregate-my-wealth] of turtles"
"mean-i-s" 1.0 0 -955883 true "" "if scenario = \"Irrational-I\" and num-i-s-agents > 0 and ticks > 1 [Plot mean [f-wealth] of i-s-agents]"
"mean-i-l" 1.0 0 -6459832 true "" "if scenario = \"Irrational-I\" and num-i-l-agents > 0 and ticks > 1 [Plot mean [f-wealth] of i-l-agents]"
"mean-r" 1.0 0 -1184463 true "" "if scenario = \"Random\" and num-random-agents > 0 and ticks > 1 [Plot mean [f-wealth] of random-agents]"

SLIDER
240
219
412
252
num-i-s-agents
num-i-s-agents
0
100
18.0
1
1
NIL
HORIZONTAL

SLIDER
240
260
412
293
num-i-l-agents
num-i-l-agents
0
30
16.0
1
1
NIL
HORIZONTAL

SLIDER
240
302
412
335
num-i-h-agents
num-i-h-agents
0
30
16.0
1
1
NIL
HORIZONTAL

MONITOR
535
352
592
397
Mean-t
(mean [f-wealth] of turtles)
2
1
11

MONITOR
612
350
669
395
mean-m
mean [f-wealth] of masters
2
1
11

MONITOR
684
350
744
395
mean-i-s
(mean [f-wealth] of i-s-agents)
2
1
11

MONITOR
757
350
814
395
mean-i-l
(mean [f-wealth] of i-l-agents)
2
1
11

MONITOR
827
349
889
394
mean-i-h
(mean [f-wealth] of i-h-agents)
2
1
11

MONITOR
910
350
981
395
mean-r-ag
(mean [f-wealth] of random-agents)
2
1
11

MONITOR
432
351
521
396
Sistem wealth
sum [f-wealth] of turtles
2
1
11

MONITOR
781
10
849
55
low-number
sum low-number
17
1
11

MONITOR
857
10
922
55
s-number
sum stable-number
17
1
11

MONITOR
926
10
992
55
h-number
sum high-number
17
1
11

MONITOR
995
351
1061
396
mean-meta
((sum [f-wealth] of i-l-agents) + (sum [f-wealth] of i-h-agents) + (sum [f-wealth] of i-s-agents)) / (count i-s-agents + count i-l-agents + count i-h-agents)
2
1
11

SWITCH
26
367
144
400
replication?
replication?
1
1
-1000

SLIDER
16
417
188
450
num-r1-agents
num-r1-agents
1
48
1.0
1
1
NIL
HORIZONTAL

MONITOR
204
411
301
456
mean-repl
((sum [f-wealth] of r1-agents) + (sum [f-wealth] of r2-agents) + (sum [f-wealth] of r3-agents)) / (count r1-agents + count r2-agents + count r3-agents)
2
1
11

MONITOR
203
361
300
406
TW-repl
(sum [f-wealth] of r1-agents) + (sum [f-wealth] of r2-agents) + (sum [f-wealth] of r3-agents)
2
1
11

SWITCH
266
10
369
43
Timer?
Timer?
1
1
-1000

@#$#@#$#@
## WHAT IS IT?

This is an agent based model developed for Santa Fe Institute 2018 Complexity Chalenge.
The startegy used by a rational agent from this model wound up generating the best strategy in the Code Tournament.

## HOW IT WORKS

The rules used by the agents are described in the write-up which is a response to the
Santa Fe Institute 2018 Spring Complexity Challenge.The write up as well as the winning code is avalable at: https://www.complexityexplorer.org/challenges/pages/solution-gallery

## HOW TO USE IT

1. Select scenario (one out of five). For the write-up the core scenarion is "Irrational-I"

2. Set the number of agents (by the sliders "num-random-agents" (for Random scenario), "num-masters", "num-i-s-agents", "num-i-l-agents", "num-i-h-agents", "num-r1-agents" (for Meta scenarios)

3. Timer for a standard run should be "off"

4. Replication switch should be "off" except "Merta" scenarios.

5. Press "Setup" and "Go" buttons. This will run the selected scenario with the set number of agents.

6. Plot areas show the payoff in low and high pools (left) and mean cumulative wealth of diffrent classes of agents during the run (right).

7. Monitors show the numeric values of parameters.

NB: The standard scenario manly takled in the write-up is "Irrational-I" with 18 "i-s-agents", 16 "i-l-agents", 16 "i-h-agents" and 3 masters. 


## THINGS TO NOTICE

Observe the dinamics of the wealth of master-agents with the above scenario. The write-up provides much more possibilities to focus on and try.


## CREDITS AND REFERENCES

This model was developed by Victor Iapascurta, MD. At time of development he was in the Department of Anesthesia and Intensive Care at University of Medicine and Pharmacy in Chisinau, Moldova / ICU at City Emergency Hospital in Chisinau. Please email any questions or comments to viapascurta@yahoo.com

The model was created in NetLogo 6.0.3 and updated to 6.2.0 version, Wilensky, U. (1999). NetLogo. http://ccl.northwestern.edu/netlogo/. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL as a responce to SFI 2018 Complexity Challenge. 
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="experiment" repetitions="5" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <metric>count turtles</metric>
    <enumeratedValueSet variable="num-i-h-agents">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-random-agents">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-i-s-agents">
      <value value="13"/>
    </enumeratedValueSet>
    <steppedValueSet variable="max-tau" first="0.5" step="0.5" last="3"/>
    <enumeratedValueSet variable="num-masters">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="t-threshold">
      <value value="32"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Scenario">
      <value value="&quot;Irrational-I&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-i-l-agents">
      <value value="8"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment-1" repetitions="5" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <metric>round (mean [aggregate-my-wealth] of masters)</metric>
    <enumeratedValueSet variable="num-i-h-agents">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-random-agents">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-i-s-agents">
      <value value="13"/>
    </enumeratedValueSet>
    <steppedValueSet variable="max-tau" first="0.5" step="0.5" last="3"/>
    <enumeratedValueSet variable="num-masters">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="t-threshold">
      <value value="32"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Scenario">
      <value value="&quot;Irrational-I&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-i-l-agents">
      <value value="8"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <metric>count turtles</metric>
    <enumeratedValueSet variable="num-i-h-agents">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-random-agents">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-i-s-agents">
      <value value="13"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-tau">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-masters">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="t-threshold">
      <value value="32"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Scenario">
      <value value="&quot;Irrational-I&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-i-l-agents">
      <value value="8"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment" repetitions="10" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <metric>sum [f-wealth] of turtles</metric>
    <enumeratedValueSet variable="num-i-h-agents">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-random-agents">
      <value value="50"/>
      <value value="48"/>
      <value value="46"/>
      <value value="44"/>
      <value value="42"/>
      <value value="40"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-i-s-agents">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-tau">
      <value value="1"/>
    </enumeratedValueSet>
    <steppedValueSet variable="num-masters" first="0" step="2" last="10"/>
    <enumeratedValueSet variable="t-threshold">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Scenario">
      <value value="&quot;Random&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-i-l-agents">
      <value value="0"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment_TW_NM" repetitions="1" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <metric>sum [f-wealth] of turtles</metric>
    <enumeratedValueSet variable="num-i-h-agents">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-random-agents">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-i-s-agents">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-tau">
      <value value="1"/>
    </enumeratedValueSet>
    <steppedValueSet variable="num-masters" first="0" step="2" last="20"/>
    <enumeratedValueSet variable="t-threshold">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Scenario">
      <value value="&quot;Random&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-i-l-agents">
      <value value="0"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment" repetitions="10" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <metric>sum [f-wealth] of turtles</metric>
    <enumeratedValueSet variable="num-i-h-agents">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-random-agents">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-i-s-agents">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-tau">
      <value value="1"/>
    </enumeratedValueSet>
    <steppedValueSet variable="num-masters" first="1" step="2" last="30"/>
    <enumeratedValueSet variable="t-threshold">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Scenario">
      <value value="&quot;Random&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-i-l-agents">
      <value value="0"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment-I" repetitions="10" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <metric>sum [f-wealth] of turtles</metric>
    <enumeratedValueSet variable="num-i-h-agents">
      <value value="15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-random-agents">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-i-s-agents">
      <value value="18"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-tau">
      <value value="1"/>
    </enumeratedValueSet>
    <steppedValueSet variable="num-masters" first="0" step="2" last="30"/>
    <enumeratedValueSet variable="t-threshold">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Scenario">
      <value value="&quot;Irrational-I&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-i-l-agents">
      <value value="15"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment" repetitions="20" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <metric>sum [f-wealth] of turtles</metric>
    <enumeratedValueSet variable="num-i-h-agents">
      <value value="15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-random-agents">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-i-s-agents">
      <value value="18"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-tau">
      <value value="1"/>
    </enumeratedValueSet>
    <steppedValueSet variable="num-masters" first="0" step="1" last="10"/>
    <enumeratedValueSet variable="t-threshold">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Scenario">
      <value value="&quot;Irrational-I&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-i-l-agents">
      <value value="15"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment" repetitions="20" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <metric>count turtles</metric>
    <enumeratedValueSet variable="num-i-h-agents">
      <value value="16"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-random-agents">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-i-s-agents">
      <value value="18"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-tau">
      <value value="1"/>
    </enumeratedValueSet>
    <steppedValueSet variable="num-masters" first="0" step="1" last="10"/>
    <enumeratedValueSet variable="t-threshold">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Scenario">
      <value value="&quot;Irrational-I&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-i-l-agents">
      <value value="16"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment" repetitions="20" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <metric>sum [f-wealth] of turtles</metric>
    <enumeratedValueSet variable="num-i-h-agents">
      <value value="16"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-random-agents">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-i-s-agents">
      <value value="18"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-tau">
      <value value="1"/>
    </enumeratedValueSet>
    <steppedValueSet variable="num-masters" first="0" step="1" last="10"/>
    <enumeratedValueSet variable="t-threshold">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Scenario">
      <value value="&quot;Irrational-I&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-i-l-agents">
      <value value="16"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment" repetitions="50" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <metric>sum [f-wealth] of turtles</metric>
    <enumeratedValueSet variable="num-i-h-agents">
      <value value="16"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-random-agents">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-i-s-agents">
      <value value="18"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-tau">
      <value value="1"/>
    </enumeratedValueSet>
    <steppedValueSet variable="num-masters" first="0" step="1" last="25"/>
    <enumeratedValueSet variable="t-threshold">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Scenario">
      <value value="&quot;Irrational-I&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-i-l-agents">
      <value value="16"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment" repetitions="10" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <metric>(sum [f-wealth] of r1-agents) + (sum [f-wealth] of r2-agents) + (sum [f-wealth] of r3-agents)</metric>
    <metric>((sum [f-wealth] of r1-agents) + (sum [f-wealth] of r2-agents) + (sum [f-wealth] of r3-agents)) / (count r1-agents + count r2-agents + count r3-agents)</metric>
    <metric>((sum [f-wealth] of i-l-agents) + (sum [f-wealth] of i-h-agents) + (sum [f-wealth] of i-s-agents)) / (count i-s-agents + count i-l-agents + count i-h-agents)</metric>
    <enumeratedValueSet variable="num-i-h-agents">
      <value value="16"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Timer?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-random-agents">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-r1-agents">
      <value value="1"/>
      <value value="3"/>
      <value value="5"/>
      <value value="10"/>
      <value value="15"/>
      <value value="20"/>
      <value value="25"/>
      <value value="30"/>
      <value value="40"/>
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-i-s-agents">
      <value value="18"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="max-tau">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-masters">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="t-threshold">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Scenario">
      <value value="&quot;Meta-1&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="replication?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-i-l-agents">
      <value value="16"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
