globals[
  r         ; realized return
  D         ; demand
  I         ; indice
  p_t-1     ; price t - 1
  p_t       ; price
  buyer     ; total buyer
  seller    ; total seller
  hold      ; total hold
  t_w_DEI   ; time of hold winner shares of DEI agent
  c_w_DEI   ; count of total winner operation DEI agent
  t_l_DEI   ; time of hold loss shares of DEI agent
  c_l_DEI   ; count of total of loss operation DEI agent
  t_w_STP   ; time of hold winner shares of STOP agent
  c_w_STP   ; count of total of winner operation STOP agent
  t_l_STP   ; time of hold loss shares of STOP agent
  c_l_STP   ; count of total of loss operation STOP agent
]

patches-own[
  q            ; buy price
  B            ; information from neighbor -> buy
  S            ; information from neighbor -> sell
  H            ; information from neighbor -> hold
  xi           ; expected return
  lambda       ; Prospect theory parameter
  delta        ; Stop loss rule parameter
  beta         ; equation 4 parameter
  Pb_B         ; probability to buy - equation 9
  Pb_S         ; probability to sell - equation 9
  Pb_N         ; probability to hold - equation 9
  DEI?         ; disposition-effect investors
  STP?         ; stop-loss investors
  buyer?       ; auxiliary variable
  seller?      ; auxiliary variable
  psell        ; auxiliary variable
  transactions ; total number of transactions
  Wealth       ; wealtg of an agent
  time1        ; auxiliar variable
]

to setup
  if random? = false [random-seed 12345]     ; fixed seed of experiment
  clear-all     ; clean previous simulations
  ask patches[
    let t random-float 1                                 ; auxiliary variable distributed between zero and one
    ifelse t < STP [ set STP? true set DEI? false] [     ; handing agents among STP e DEI
      set STP? false set DEI? true ]                     ; handing agents among STP e DEI
    set buyer? false                                     ; cleaning variable
    set seller? false                                    ; cleaning variable
    set pcolor (white)                                   ; white for agents not operated in the period
    set q 0                                              ; purchase price equal to zero - initial setup
    set psell 0                                          ; selling price of zero - initial setup
    ifelse (i. = 1) or (i. = 0) [ set xi 0.01 ] [ set xi ((x_max / i.) * random i.) + 0.01]    ; create heterogeneous expectations
    set lambda LambdaTeste * xi                                 ; recording individual value
    set Wealth 100                                       ; arbitrary starting value of individual Wealth, not influence the results of experiments
    set transactions 0                                   ; resetting number of transactions the agent
    set delta random-float .02                           ; creating a particular value of the delta, used in the STOP strategy
    set beta random-float xi ]                           ; individualde beta value
  set I 0                                                ; setup indice
  set p_t P_initial                                      ; setup initial price
  set p_t-1 P_initial                                    ; setup initial price
  set t_w_DEI 0
  set c_w_DEI 0
  set t_l_DEI 0
  set c_l_DEI 0
  set t_w_STP 0
  set c_w_STP 0
  set t_l_STP 0
  set c_l_STP 0
  reset-ticks
end

to fetch-information     ; Structure of "Equation 4"
  ifelse q != 0     [ set B omega + count neighbors with [ pcolor = blue ] ] [ set B count neighbors with [ pcolor = blue ] ]           ; value for B, adding omega own information using color to verify information from neighbors
  ifelse psell != 0 [ set S omega + count neighbors with [ pcolor = red  ] ] [ set S count neighbors with [ pcolor = red  ] ]           ; value for S, adding omega own information using color to verify information from neighbors
  ifelse (q = 0) and (psell = 0) [ set H count neighbors with [ pcolor = white ] ] [ set H count neighbors with [ pcolor = white ] ]    ; value for H, by adding omega own information using color to verify information from neighbors
  set Pb_B (B / (B + S + H)) + beta * I                                                                                                 ; probabilities buy
  set Pb_S (S / (B + S + H)) + beta * I                                                                                                 ; probabilities sell
  set Pb_N (H / (B + S + H))                                                                                                            ; probabilities hold
end

to agent-STP   ; Structure of "Equation 9"
  let t random-float 1                                                                                 ;  auxiliary variable
  ifelse ticks < 100 [ ifelse t < (1 / 3) [ buy ] [ ifelse t > ( 2 / 3) [ sell ] [ not-operate ] ] ] [ ; first 100 simulations are used to setup the model
  ifelse q = 0 [
    ifelse (r) > (delta) [ STP-buy ] [ not-operate ]                                                   ; opening position, "equation 9" if the last return is greater than delta agent will operate.
    ] [
    ifelse p_t > q [                                                                                   ; checks if the agent closes the position or not, continuing "equation 9"
      ifelse (p_t - q) > (lambda * q) [
        if ticks > 200 [set t_w_STP (t_w_STP + (ticks - time1))]
        if ticks > 200 [set c_w_STP (c_w_STP + 1)]
        STP-sell ] [ not-operate ] ] [                                                                 ; Gain more than goal, compulsory closing the position
      ifelse (q - p_t) > (xi * q) [
        if ticks > 200 [set t_l_STP (t_l_STP + (ticks - time1))]
        if ticks > 200 [set c_l_STP (c_l_STP + 1)]
        STP-sell ] [ not-operate ] ] ] ]                                                               ; maximum loss reached, compulsory closing the position
end

to buy ; structure for the agent to make a purchase
  set buyer? true          ; records the information that the agent made a purchase
  set seller? false        ; records that the agent not made a sale
  set pcolor (blue)        ; blue for agents who buy
  set q p_t                ; records of purchase price q
  set psell 0              ; sales price equal to zero means that the agent not made a sale
  set time1 ticks          ; counting time with posses share
end

to sell ; structure for the agent making a sale
  set buyer? false         ; means not made a purchase
  set seller? true         ; records that held a sale
  set pcolor (red)         ; red agents to sell.
  set q 0                  ; purchase price equal to zero means that the agent not bought.
  set psell p_t            ; records sales price
  set time1 ticks          ; counting time with posses share
end

to closing-operation-high ; agents MUST NOT use strategy STOP
  ;; p_t > q ---> GAIN
  ifelse (p_t - q) > (xi * q) [                                        ; this structure means: if (as I am earning) is greater than (My individual goal of GAIN)
    ifelse (random-float 1) < ((p_t - q - (xi * q)) / (xi * q)) [      ; if yes, verifies how much above the target ...
      set transactions transactions + 1                                ; ... and increases the probability as the gain exceeds the goal.
      set Wealth Wealth * (1 + ((p_t - q) / q))                        ; Wealth updates the agent
      set buyer? false
      set seller? true
      set pcolor (red)
      set q 0
      set psell 0
      if ticks > 200 [set t_w_DEI (t_w_DEI + (ticks - time1))]
      if ticks > 200 [set c_w_DEI (c_w_DEI + 1)]
      ] [ not-operate ]
      ] [ not-operate ]
end

to closing-operation-falling ; agents MUST NOT use strategy STOP
  ;; p_t < q ---> LOSS
  ifelse (q - p_t) > (lambda * q) [ ; this structure means: if (as I am earning) is greater than (individual goal - bearable loss - individual LOSS)
    ifelse (random-float 1) < ((q - p_t - (q * lambda)) / (lambda * q)) [ ; probability to end position
      set transactions transactions + 1     ;
      set Wealth Wealth * (1 + ((p_t - q) / q))     ;
      set buyer? false     ;
      set seller? true     ;
      set pcolor (red)     ;
      set q 0              ;
      set psell 0          ;
      if ticks > 200 [set t_l_DEI (t_l_DEI + (ticks - time1))]
      if ticks > 200 [set c_l_DEI (c_l_DEI + 1)]
      ] [ not-operate ]    ;
      ] [ not-operate ]    ;
end

to closing-shortposition-high ; agents MUST NOT use strategy STOP      - Agent conducted an asset sale, gain if the asset falls and loses if the asset rise
  ;; p_t > psell ---> LOSS
  ifelse (p_t - psell) > (lambda * psell) [                                           ; this structure means: if (as I am earning) is greater than (individual goal - bearable loss - individual LOSS)
    ifelse (random-float 1) < ((p_t - psell - (lambda * psell)) / (lambda * psell)) [ ; probability to end position
      set transactions transactions + 1
      set Wealth Wealth * (1 + ((psell - p_t) / psell))
      set buyer? true
      set seller? false
      set pcolor (blue)
      set q 0
      set psell 0
      if ticks > 200 [set t_l_DEI (t_l_DEI + (ticks - time1))]
      if ticks > 200 [set c_l_DEI (c_l_DEI + 1)]
      ] [ not-operate ]
      ] [ not-operate ]
end

to closing-shortposition-falling ; agents MUST NOT use strategy STOP
  ;; psell > p_t ---> GAIN
  ifelse (psell - p_t) > (xi * psell) [                                                ; this structure means: if (as I am earning) is greater than (My individual goal of GAIN)
    ifelse (random-float 1) < ((psell - p_t - (xi * psell)) / (xi * psell)) [ ;
      set transactions transactions + 1
      set Wealth Wealth * (1 + ((psell - p_t) / psell))
      set buyer? true
      set seller? false
      set pcolor (blue)
      set q 0
      set psell 0
      if ticks > 200 [set t_w_DEI (t_w_DEI + (ticks - time1))]
      if ticks > 200 [set c_w_DEI (c_w_DEI + 1)]
      ] [ not-operate ]
    ] [ not-operate ]
end

to STP-buy ;; agents using order STOP
  set buyer? true
  set seller? false
  set pcolor (blue)
  set q p_t
  set psell 0
  set time1 ticks
end

to STP-sell ;; agents using order STOP
  set transactions transactions + 1
  set Wealth Wealth * (1 + ((p_t - q) / q))
  set buyer? false
  set seller? true
  set pcolor (red)
  set q 0
  set psell 0
end

to not-operate ;; all agents
  set buyer? false
  set seller? false
  set pcolor (white)
end

to traders    ; agents in the distribution of heterogeneity received minimum value of "x". Very active agents in the real market would be daytrader.
  let t random-float 1             ; t = auxiliary variable; first 100 simulations are used to setup the model
  ifelse ticks < 100 [ ifelse t < (1 / 3) [ buy ] [ ifelse t > ( 2 / 3) [ sell ] [ not-operate ] ] ] [ fetch-information  ifelse t < ((beta * I) + Pb_B) [ buy ] [ ifelse t > (1 - Pb_S + (beta * I)) [ sell ] [ not-operate ] ] ]
  ifelse q != 0 [ set transactions transactions + 1 set Wealth Wealth * (1 + ((p_t - q) / q)) ] [ if psell != 0 [ set Wealth Wealth * (1 + ((psell - p_t) / psell)) ]  ]
end

to agent-DEI    ; Finishing structure operation of the agent subject to the disposition effect
  let t random-float 1                                                                                             ; auxiliary variable
  ifelse ticks < 100 [ ifelse t < (1 / 3) [ buy ] [ ifelse t > ( 2 / 3) [ sell ] [ not-operate ] ] ] [             ; first 100 simulations are used to setup the model
  ifelse q != 0 [
    ifelse p_t > q [ closing-operation-high ] [ closing-operation-falling ] ] [                                    ; checks whether the agent is winning or losing, and calls one of the functions
    ifelse psell != 0 [                                                                                            ; agent sold
      ifelse p_t > psell [ closing-shortposition-high ] [ closing-shortposition-falling ] ] [                      ; checks whether the agent is winning or losing, and calls one of the functions
      fetch-information
      ifelse t < (Pb_B) [ buy ] [                                                                                  ; uses equation 4 to verify that buys, sells, or does not operate
        ifelse t > (1 - Pb_S) [ sell ] [ not-operate ] ] ] ] ]
end

to I-indice ; computing indice I
  ifelse (buyer + seller ) != 0 [ ifelse ISTeste = true [ if ((ticks mod 50) = 0) and (ticks > 1) [ set I ((buyer - seller) / (buyer + seller + hold)) + (I_Choque) ] ] [ set I 0 ] ] [ set I 0 ]
end

to go ; Run
  ask patches[
    ifelse xi = 0.01 [ traders ] [
      ifelse STP? [ agent-STP ] [ agent-DEI ] ] ] ; checking which type of agent. Calls one of its functions as above.
  set buyer count patches with [buyer?]
  set seller count patches with [seller?]
  set hold (max-pycor * max-pxcor) - buyer - seller
  ifelse (buyer + seller) != 0 [ set D ((buyer - seller) / (buyer + seller + hold)) ] [ set D 0 ] ; computing demand period
  set p_t (((exp(D) - exp(- D)) / (exp(D) + exp(- D)) + 1 ) * p_t-1)                              ; computing the price period
  set r (ln(p_t) - ln(p_t-1))                                                                     ; computing the first return period
  set p_t-1 p_t                                                                                   ; updating price of the previous period
  I-indice                                                                                        ; calling function indice I
  tick ; new period

end







@#$#@#$#@
GRAPHICS-WINDOW
837
10
1318
492
-1
-1
4.73
1
10
1
1
1
0
1
1
1
0
99
0
99
0
0
1
ticks
30.0

BUTTON
1
10
76
43
Setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
75
10
158
43
GoOnce
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
76
43
159
76
Go!
if ticks < 3000 [go ]\n
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
255
10
441
43
STP
STP
0
1
0.0
.01
1
NIL
HORIZONTAL

SLIDER
260
145
432
178
PTI
PTI
0
1
0.3
.01
1
NIL
HORIZONTAL

SWITCH
384
11
474
44
ISteste
ISteste
0
1
-1000

PLOT
0
76
835
214
Returns
NIL
NIL
0.0
10.0
1.0
0.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "if ticks > 200 [plot r]"

MONITOR
691
10
767
55
NIL
t_l_DEI
0
1
11

MONITOR
608
10
691
55
NIL
c_w_DEI
0
1
11

PLOT
0
214
834
380
Price
NIL
NIL
0.0
10.0
1000.0
0.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "if ticks > 200 [plot p_t]"

MONITOR
524
10
608
55
NIL
t_w_DEI
0
1
11

INPUTBOX
311
10
361
70
x_max
0.16
1
0
Number

INPUTBOX
261
10
311
70
i.
4.0
1
0
Number

INPUTBOX
189
383
254
443
I_Choque
0.0
1
0
Number

PLOT
0
379
834
514
Volume
NIL
NIL
0.0
10.0
10000.0
0.0
true
false
"" ""
PENS
"default" 1.0 1 -16777216 true "" "if ticks > 200 [plot (buyer + seller) ]"

SWITCH
164
15
261
48
Random?
Random?
0
1
-1000

INPUTBOX
361
10
417
70
P_initial
100.0
1
0
Number

CHOOSER
157
10
261
55
omega
omega
0.01 0.1 1 10 100
3

MONITOR
766
10
838
55
NIL
c_l_DEI
0
1
11

INPUTBOX
416
10
494
70
LambdaTeste
1.5
1
0
Number

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="lambda_Test" repetitions="10" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <exitCondition>ticks &gt; 3000</exitCondition>
    <metric>t_w_DEI   ; time of hold winner shares of DEI agent</metric>
    <metric>c_w_DEI   ; count of total winner operation DEI agent</metric>
    <metric>t_l_DEI   ; time of hold loss shares of DEI agent</metric>
    <metric>c_l_DEI</metric>
    <enumeratedValueSet variable="x_max">
      <value value="0.16"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="I_Choque">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Random?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ISteste">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="i.">
      <value value="4"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="STP">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="PTI">
      <value value="0.3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="omega">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="P_initial">
      <value value="100"/>
    </enumeratedValueSet>
    <steppedValueSet variable="LambdaTeste" first="0.1" step="0.1" last="3"/>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
