                                                                                                                                                                                                                                                                                   globals[
  A_no_list            ;; number of type-A agents in each iteration
  B_no_list            ;; number of type-B agents in each iteration
  nb                   ;; type of neighborhood
  latane_denominator   ;; depends on type of nb (4, 12, 24)
  result               ;; "pending" or "stable"; if "stable" model stops
]

turtles-own[
  class                ;; agent's type i.e. A or B
  value                ;; 1 or -1 depending on the class
  action               ;; describes action of the agent ("stay", "change" or "move")
  movement-counter     ;; counts how many times agent tried to move this turn
  patch-2              ;; the patch agent occupied 2 iterations earlier
  patch-1              ;; the patch agent occupied 1 iteration earlier
  class-2              ;; agent's type 2 iterations earlier
  class-1              ;; agent's type 1 iteration earlier
]




to setup
  clear-all
  set-neighbourhood
  set A_no_list []
  set B_no_list []
  ask patches[
    if random-float 1 < density
    [
      let val 1
      if random-float 1 > type_A [set val -1]
      sprout 1
      [
        set-class val
        set shape "square"
        set movement-counter 0
      ]
    ]
  ]
  set result "pending"
  reset-ticks
end


to go
  if ticks = 1
  [
    ask turtles
    [
      set patch-1 patch-here
      set class-1 class
    ]
  ]
  if ticks > 1
  [ ask turtles
    [
      set patch-2 patch-1
      set patch-1 patch-here
      set class-2 class-1
      set class-1 class
    ]
  ]
  if rule = "MR" [ ask turtles [ MR-rule ] ]
  if rule = "UR" [ ask turtles [ UR-rule ] ]
  if rule = "ULR" [ ask turtles [ ULR-rule ] ]
  ask turtles [ make-action ]
  count-population
  tick
  if ticks > 1 [ check-stop-conditions ]
  if ((result != "pending") or (ticks >= 1000)) [ stop ]
end


to set-class [ class-value ]
  ifelse class-value = 1
  [
    set class "A"
    set value 1
    set color green
  ]
  [
    set class "B"
    set value -1
    set color red
  ]
end


to set-neighbourhood
  if range = 1
  [
    set nb [
              [-1 0]
           [0 -1] [0 1]
               [1 0]
           ]
  ]
  if range = 2
  [
    set nb [
                        [-2 0]
                [-1 -1] [-1 0] [-1 1]
           [0 -2] [0 -1]       [0 1] [0 2]
                  [1 -1] [1 0] [1 1]
                         [2 0]
           ]
  ]
  if range = 3
  [
    set nb [
                              [-3 0]
                      [-2 -1] [-2 0] [-2 1]
               [-1 -2] [-1 -1] [-1 0] [-1 1] [-1 2]
          [0 -3] [0 -2] [0 -1]       [0 1]  [0 2] [0 3]
                 [1 -2] [1 -1] [1 0] [1 1]  [1 2]
                        [2 -1] [2 0] [2 1]
                               [3 0]
           ]
  ]
end


to set-direction
  set heading ((random 4) * 90)
end

to move
  fd 1
  if any? other turtles-here [ move ]   ;; if patch is occupied - repeat
end

to moving-procedure
  let p patch-here
  ifelse movement-counter = 0
  [ set-direction ]
  [ set heading heading + 90 ]
  move
  ifelse ((p = patch-here) and (movement-counter < 4))
  [
   ;; if agent ends in the same patch - repeat whole procedure and increase counter
    set movement-counter movement-counter + 1
    moving-procedure
  ]
  [ set movement-counter 0 ]
end


to MR-rule
  set action "stay"                                     ;; default state
  let nn turtles at-points nb                           ;; take all turtles in neighbourhood
  let influence sum [value] of nn                       ;; sum their values
  ifelse influence = 0                                  ;; infl==0 means that no. of A and B are the same
  [ set action "move" ]
  [ if influence * value < 0 [ set action "change" ] ]  ;; infl*value is < 0 when most neighbours are opposite type
end

to UR-rule
  set action "stay"                                     ;; default state
  let nn turtles at-points nb                           ;; take all turtles in neighbourhood
  let influence sum [value] of nn                       ;; sum their values
  ifelse count nn = abs influence                       ;; no. of neighbors==abs(infl) means that all nn are the same
  [
    ifelse influence = 0                                ;; in that case influence = 0 means that there are no neighbours
    [ set action "move" ]                               ;; and agent just moves
    [
      if influence * value < 0 [ set action "change" ]  ;; if influence <> 0 then check if neighbours' type is different
    ]                                                   ;; infl*value is < 0 when neighbours are opposite type - change
  ]                                                     ;; if not, nothing changes (default state, i.e. "stay")
  [ set action "move" ]                                 ;; move if not all neighbours are the same
end

to ULR-rule
  set action "stay"                                     ;; default state
  let nn turtles at-points nb                           ;; take all turtles in neighbourhood
  let influence sum [value] of nn                       ;; sum their values
  ifelse count nn = abs influence                       ;; no. of neighbors==abs(infl) means that all nn are the same
  [
    ifelse influence = 0                                ;; in that case influence = 0 means that there are no neighbours
    [ set action "move" ]                               ;; and agent moves
    [
      if influence * value < 0                          ;; if influence <> 0 then check if neighbours' type is different
      [ set latane_denominator 4                        ;;
        if range = 2 [ set latane_denominator 12 ]      ;; denominator depends on type of neighbourhood
        if range = 3 [ set latane_denominator 24 ]      ;;
        if random-float 1 < sqrt((count nn) / latane_denominator) [ set action "change" ]  ;; change only when
     ]                                                                                     ;; random r < sqrt(k/lat_denom)
    ]
  ]
  [ set action "move" ]
end


to make-action
  if action = "move" [ if random-float 1 < movement_prob [ moving-procedure ] ]
  if action = "change" [ set-class (-1 * value) ]
end

to count-population
  set A_no_list lput (count turtles with [class = "A"]) A_no_list
  set B_no_list lput (count turtles with [class = "B"]) B_no_list
end


to check-stop-conditions
  ifelse (abs (count turtles with [class = "A"] - count turtles with [class = "B"]) = count turtles)
  [ set result "stable" ]    ;; all turtles are the same
  [                          ;;
    let change 0
    ask turtles
    [
      if ((patch-here != patch-2) or (class != class-2))
      [
        set change 1
      ]
    ]
    if change = 0 [ set result "stable" ] ;; oscilating or not changing
  ]
end


;; not used but now can be useful if greater ranges are considered in the future
to set-latane
 let i 0
 repeat range
 [
   set i (i + 1)
   set latane_denominator latane_denominator + (i * 4)
 ]
end
@#$#@#$#@
GRAPHICS-WINDOW
273
10
733
491
-1
-1
9.0
1
8
1
1
1
0
1
1
1
-24
25
-24
25
0
0
1
ticks
30.0

BUTTON
13
10
76
43
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
93
10
156
43
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
176
10
253
43
go-once
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
81
57
253
90
density
density
0
1
0.7
0.05
1
NIL
HORIZONTAL

SLIDER
81
96
253
129
type_A
type_A
0
1
0.5
0.05
1
NIL
HORIZONTAL

SLIDER
81
136
253
169
range
range
1
3
2
1
1
NIL
HORIZONTAL

SLIDER
81
174
253
207
movement_prob
movement_prob
0
1
1
0.05
1
NIL
HORIZONTAL

CHOOSER
114
214
252
259
rule
rule
"MR" "UR" "ULR"
0

PLOT
7
340
264
490
Agents' type share
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -13840069 true "" "plot count turtles with [class = \"A\"]"
"pen-1" 1.0 0 -2674135 true "" "plot count turtles with [class = \"B\"]"

MONITOR
184
272
251
317
NIL
result
17
1
11

@#$#@#$#@
## WHAT IS IT?

This model was designed to describe consumer’s decision-making process based on social influence (word-of-mouth) in a duopoly market structure (i.e. when only two producers exist in the market) and evaluate how details introduced on the microscopic level influence the macroscopic behavior of the system.

## HOW IT WORKS

The model is a simple two-dimensional cellular automaton. Each cell can be in one of three states: empty (black), occupied by an agent of type A  (green, a customer of company A) or occupied by an agent of type B  (red, a customer of company B).  Each agent can change its state under social influence of the neighborhood or move to the nearest empty cell in one of four randomly chosen directions with probability ‘movement_prob’ in case of uncertainty. Uncertainty is defined as a lack of majority (for the MR rule) or a lack of unanimity (for the UR and ULR rules) in the neighborhood. The ULR rule is based on Latane’s theory that says that the power of social influence increases with the size of the influence group, while the UR rule is independent of the size of the group. All cells in the system are updated synchronously according to the following rules:
1.An occupied cell can change its state due to the social influence of neighbors. For the MR rule an occupied cell takes the state which is represented by the majority of the occupied cells in the neighborhood. For the UR and ULR rules, a cell is influenced only by the unanimous majority.
2.If an occupied cell cannot make a decision on the basis of the neighborhood (in a case of uncertainty), for example, in absence of majority (MR) or unanimity (UR and ULR), it moves to the nearest empty place in a randomly chosen direction (N, E, S or W) with probability ‘movement_prob’.


## HOW TO USE IT

Click the ‘setup’ button to set up the agents. There are approximately equal numbers of green (A) and red (B) agents (‘type_A’=0.5). There is at most one agent in each cell (patch) and some cells are empty (black). The ‘density’ slider controls the occupancy density of the neighborhood (and thus the total number of agents). It takes effect the next time you click SETUP. Click GO to start the simulation. If agents are unconvinced by the neighborhood (no majority for the MR rule or unanimity for the ULR and UR rules), they move to a nearby patch. We use periodic boundary conditions, so that patches on the bottom edge are neighbors of patches on the top, similarly for left and right.
Within this model we are able to test how the following factors influence results:
1.Density of occupied cells (density) varies from 0 (all cells are empty) to 1 (all cells are occupied)
2.The market share of two companies (type_A) – how many of the occupied cells are of type A (green)
3.The range of interactions – we use here von Neumann neighborhood of range r=1,2,3
4.The probability of movement in case of uncertainty
5.The type of social influence – we test here three rules: majority (MR), unanimity (UR) and unanimity Latane rule (ULR)


## THINGS TO NOTICE

When you execute SETUP, the red and green agents are randomly distributed. Due to the rules described in section HOW IT WORKS, agents change colors and move. Eventually the system reaches a fixed state with three types of clusters - green, red and chessboard-like. Click 'go-once' button and notice that the chessboard-like structure periodically changes and thus corresponds to customers without permanent opinion (disloyal).

## THINGS TO TRY

Move slider 'range' to 2 and observe how this influences the stationary state. For r=2 the system is much more segregated. Choose other rules (UR and ULR) and observe that under unanimity rule the relaxation is longer and the system is more segregated. Try to change the number of green customers moving slider 'type_A' and look what happens.

## EXTENDING THE MODEL

There are several possibilities to extend the model including the introduction of the external field (advertisement) or independent agents that are not susceptible to the social influence. Another possibility is to increase the number of possible states, which would allow to study the oligopoly structure.

## RELATED MODELS

See also the following models in the NetLogo Models Library: Rumor Mill, Segregation, Voting and Ising (a physics model).

## CREDITS AND REFERENCES

This model is described in
[1] Kowalska-Styczeń, K. Sznajd-Weron, Access to information in word of mouth marketing within a cellular automata model, Advances in Complex Systems 15, 1250080 (2012); DOI: 10.1142/S0219525912500804
[2] A. Kowalska-Styczeń, K. Sznajd-Weron, From consumer decision to market share - majority or unanimity?, Preprint (2016)
The work was supported by funds from the National Science Centre (NCN) through grant no. 2014/15/B/HS4/04433 and 2013/11/B/HS4/01061.
Software developer: Tomasz Owczarek, Silesian University Of Technology,  Faculty of Organization and Management

## HOW TO CITE

If you mention this model or the NetLogo software in a publication, we ask that you include the citations below.

For the model itself please cite:
[1] Kowalska-Styczeń, K. Sznajd-Weron, Access to information in word of mouth marketing within a cellular automata model, Advances in Complex Systems 15, 1250080 (2012)

Please cite the NetLogo software as:
[2] Wilensky, U. (1999). NetLogo. http://ccl.northwestern.edu/netlogo/. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 26                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                